<?php

defined('PF_VERSION') OR exit('Access denied');

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
class Pf_Post_Category_Controller extends Pf_Plugin_Controller
{

    private $rules = array(
        'name' => 'required|min_len,2|max_len,255',
        'description' => 'max_len,255'
    );
    private $status;

    public function __construct()
    {
        parent::__construct();
        $this->view->set_path('post', true);
        $this->category = new Pf_Lib_Category();
        $this->status = array(1 => __('Published', 'post'), 0 => __('Unpublished', 'post'));
        $this->acl = array(1, 2);
        $this->check_acl();
    }

    public function main()
    {
        $conditions = 'category_type = ?';
        $param = array(1);
        $url = admin_url('admin-page=post&sub_page=category', false);
        if ($this->input->has_get('status')) {
            $conditions .= " and category_status = ? ";
            $status = $this->input->get('status', true) == 1 ? 1 : 0;
            $param[] = $status;
            $url .= "&status={$status}";
        }
        if ($this->input->has_get('kw')) {
            $conditions .= " and category_name like ? ";
            $param[] = "%{$this->input->get('kw') }%";
            $url .= "&kw={$this->input->get('kw') }";
        }

        /* Count paging */
        $total = $this->category->count($conditions, $param);
        $page = $this->input->has_get('current') ? (int) $this->input->get('current', true) - 1 : 0;
        $per_page = (int) $page * NUM_PER_PAGE;

        /* Get data */
        $condition_get = " WHERE {$conditions} ORDER BY id asc LIMIT {$per_page}, " . NUM_PER_PAGE;
        $categories = $total > 0 ? $this->category->get('pf_categories.id,category_name,category_type,category_parent,category_description,category_status,user_name', true, $condition_get) : array();
        $pagination = new Pf_Paginator($total, NUM_PER_PAGE, 'current');
        $this->data['categories'] = $categories;
        $this->data['pagination'] = $pagination;
        $this->data['url'] = $url;
        $this->view->render('category/main', $this->data);
    }

    public function create()
    {
        if ($this->input->has_post('name')) {
            $data = $this->category->get_input();
            $data['category_author'] = current_user('user-id');
            $data['category_type'] = 1;
            $id = $this->category->insert($data, true, $this->rules);
            if ($id > 0) {
                $this->session->flash('success', __('New category is created successfully', 'post'));
                Pf_Plugin_Redirect::to('&act=edit&id=' . $id);
            } else {
                $error = $this->category->get_errors();
                $this->data['error'] = !empty($error) ? __('Please check the data field!', 'post') : __('An error has occurred. Please try again', 'post');
                $this->data['validated'] = $error;
            }
        }
        $this->data['status'] = $this->status;
        $this->data['categories'] = $this->category->dropdown(true, 'where category_type = 1');
        $this->view->render('category/create', $this->data);
    }

    public function edit()
    {
        if (!$this->input->has_get('id')) {
            Pf_Plugin_Redirect::to('act=main');
        }
        $id = (int) $this->input->get('id');
        if ($this->input->has_post('id')) {
            $data = $this->category->get_input(array('id'));
            if ($this->category->update($data, true, $this->rules, "id = ? ", $id)) {
                $this->session->flash('success', __('Category is updated successfully', 'post'));
                Pf_Plugin_Redirect::to('&act=edit&id=' . $id);
            } else {
                $error = $this->category->get_errors();
                $this->data['error'] = !empty($error) ? __('Please check the data field!', 'post') : __('An error has occurred. Please try again', 'post');
                $this->data['validated'] = $error;
            }
        }
        $this->data['cate'] = $this->category->get_by_id($id);
        $this->data['categories'] = $this->category->dropdown(true, "where id != ?", array($id));
        $this->data['status'] = $this->status;
        $this->view->render('category/edit', $this->data);
    }

    public function status()
    {
        $current = $this->input->get('current');
        if ($this->input->has_get('id') && $this->input->has_get('type')) {
            $id = $this->input->get('id');
            $status = $this->input->get('type') == 2 ? 0 : 1;
            if ($this->update_status(array('category_status' => $status), $id, array(), $current)) {
                $this->session->flash('success', __('Status is updated successfully', 'post'));
            } else {
                $this->session->flash('danger', __('An error has occurred. Please try again', 'post'));
            }
        }
        Pf_Plugin_Redirect::to('&act&id&type&current=' . $current);
    }

    public function delete()
    {
        if ($this->input->has_get('id')) {
            $id = (int) $this->input->get('id', true);
            return $this->delete_category("?", array($id));
        }
        Pf_Plugin_Redirect::to('&act=main&id&token');
    }

    public function bulk_action()
    {
        if (!$this->input->has_post('id')) {
            return false;
        }
        $action = $this->input->post('action');
        $id = $this->input->post('id');
        $condition = generate_where_in($id);
        $current = (int) $this->input->post('current');
        if ($action == 3) {
            $this->delete_category($condition, $id);
        } else {
            $this->update_status(array('category_status' => $action), $condition, $id, $current);
        }
    }

    private function update_status($data, $condition, $param, $current = '')
    {
        $result = $this->category->update($data, false, array(), "id in({$condition})", $param);
        $messages = array(
            'success' => __('Status is updated successfully', 'post'),
            'danger' => __('An error has occurred. Please try again', 'post')
        );
        $this->alertSave($messages, $result);
        Pf_Plugin_Redirect::to("&act=&status=&token&id&type&current={$current}");
    }

    private function delete_category($condition, $param)
    {
        $category = $this->category
                ->get('id,category_name,category_parent', false, "where category_type = 1");
        $delete = true;
        foreach ($category as $v) {
            if (in_array($v->category_parent, $param)) {
                $delete = false;
                break;
            }
        }
        if ($delete === true) {
            $result = $this->category->delete("id in($condition)", $param);
            $messages = array(
                'success' => __('Category is deleted successfully', 'post'),
                'danger' => __('An error has occurred. Please try again', 'post')
            );
            $this->alertSave($messages, $result);
        } else {
            $this->session->flash('danger', __('There are some post in this category. Please delete its post first', 'post'));
        }
        Pf_Plugin_Redirect::to("&act=main&current");
    }

}
